#include "server_ws.hpp"

using namespace std;

using WsServer = SimpleWeb::SocketServer<SimpleWeb::WS>;
static thread server_thread;
WsServer server;

void websokcet_server_start_proc()
{
	server.start();
}

void websocket_server_start(unsigned short port)
{
	server.config.port = port;

	auto &echo = server.endpoint["^/HelloTest/ws?$"];
	echo.on_message = [](shared_ptr<WsServer::Connection> connection, shared_ptr<WsServer::InMessage> in_message) {
		auto out_message = in_message->string();

		cout << "Server: Message received: \"" << out_message << "\" from " << connection.get() << endl;
		cout << "Server: Sending message \"" << out_message << "\" to " << connection.get() << endl;
	};

	echo.on_open = [](shared_ptr<WsServer::Connection> connection) {
		cout << "Server: Opened connection " << connection.get() << endl;
	};

	echo.on_close = [](shared_ptr<WsServer::Connection> connection, int status, const string & /*reason*/) {
		cout << "Server: Closed connection " << connection.get() << " with status code " << status << endl;
	};

	echo.on_error = [](shared_ptr<WsServer::Connection> connection, const SimpleWeb::error_code &ec) {
		cout << "Server: Error in connection " << connection.get() << ". "
			<< "Error: " << ec << ", error message: " << ec.message() << endl;
	};

	server_thread = thread(websokcet_server_start_proc);
}

void websocket_server_stop()
{
	server.stop();
	server_thread.join();
}
