#include <Windows.h>
#include <netlistmgr.h>
#include "deps/json11/json11.hpp"
#include "HttpCurl.h"
#include "curl_examples.h"

//#include <WinINet.h>  
//#pragma comment(lib, "WinINet.lib")

//#include <Urlmon.h>
//#pragma comment(lib, "Urlmon.lib")

#define UPDATE_SERVICE	"https://apps.lovense.com/app/getUpdate/smartcam/win?v=1"

bool CheckIsNetwork()
{
	CoInitialize(NULL);

	IUnknown *pUnknown = NULL;
	bool bOnline = TRUE;
	HRESULT hr = ::CoCreateInstance(CLSID_NetworkListManager, NULL, CLSCTX_ALL, IID_IUnknown, (void **)&pUnknown);
	if (SUCCEEDED(hr))
	{
		INetworkListManager *pNetworkListManager = NULL;
		if (pUnknown)
			hr = pUnknown->QueryInterface(IID_INetworkListManager, (void **)&pNetworkListManager);
		if (SUCCEEDED(hr))
		{
			VARIANT_BOOL IsConnect = VARIANT_FALSE;
			if (pNetworkListManager)
				hr = pNetworkListManager->get_IsConnectedToInternet(&IsConnect);
			if (SUCCEEDED(hr))
				bOnline = (IsConnect == VARIANT_TRUE) ? true : false;
		}

		if (pNetworkListManager)
			pNetworkListManager->Release();
	}

	if (pUnknown)
		pUnknown->Release();

	CoUninitialize();
	return bOnline;
}

std::string GetPostData()
{
	json11::Json root = json11::Json::object{
		{ "ver", "1.0.0.1" }
	};

	return root.dump();
}

bool PraseData(std::string strData, std::string& strURL)
{
	return true;
}

bool CheckUpdate(std::string& strURL)
{
	do
	{
		std::string strPostData = GetPostData();
		if (0 == strPostData.length())
			break;

		HttpCurlPost httpPost;
		if (!httpPost.Post(UPDATE_SERVICE, strPostData.c_str(), strPostData.length()))
			break;

		if (!PraseData(httpPost.GetData(), strURL))
			break;

		return (strURL.length() > 0) ? true : false;

	} while (false);

	return true;
}

bool UpdateHtmlFile(std::string& strURL)
{
	return CheckIsNetwork() && CheckUpdate(strURL);
}

