#pragma  once
#include "CRtmpSetHelp.h"
#include <obs-module.h>
#include <obs-frontend-api.h>

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include "deps/json11/json11.hpp"

#define SERVICE_PATH "service.json"

CRtmpSetHelp::CRtmpSetHelp()
{
	
}

CRtmpSetHelp::~CRtmpSetHelp()
{
}

void CRtmpSetHelp:: testjsonfile(char* jsonfile, std::string & strpase)
{

	std::filebuf in;
	if (!in.open("E:/GitCode/Messy_Test/testdata/json.data", std::ios::in))
	{
		std::cout << "fail to open file" << std::endl;
		return ;
	}

	std::istream iss(&in);

	std::istreambuf_iterator<char> eos;
	std::string s(std::istreambuf_iterator<char>(iss), eos);

	strpase = s;


}

bool  CRtmpSetHelp::ParseJsonStr(std::string  rtmpsetstr)
{

	std::string err;
	auto json = json11::Json::parse(rtmpsetstr, err);
	if (!err.empty())
	{
		blog(LOG_ERROR, "[Lovese] ParseJson fail! ");
		return false;
	}

	//std::cout << "************** show file info *****************" << std::endl;
	std::string json_str = json.dump();
	//std::cout << json_str << std::endl;
	//std::cout << "*************** start parse ****************" << std::endl;

	std::string type = json["type"].string_value();

	std::string server;
	std::string service;
	std::string key;
	std::string username;
	std::string password;
	bool buser;
	if (json["settings"].is_null())
	{
		//std::cout << "failed to get bei_jing info" << std::endl;
	}
	else
	{
		json11::Json::object object_ = json["settings"].object_items();
		server = object_["server"].string_value();
		key = object_["key"].string_value();
		buser = object_["use_auth"].bool_value();
		service = object_["service"].string_value();
		username = object_["username"].string_value();
		password = object_["password"].string_value();
	}


	bool customServer = false;
	const char *service_id = customServer
		? "rtmp_custom"
		: "rtmp_common";

	OBSData settings = obs_data_create();
	obs_data_release(settings);

	if (!customServer)
	{
		obs_data_set_string(settings, "service",
			service.c_str()/*QT_TO_UTF8(ui->service->currentText())*/);
		obs_data_set_string(settings, "server",
			server.c_str()/*QT_TO_UTF8(ui->server->currentData().toString())*/);
	}
	else
	{
		obs_data_set_string(settings, "server",
			server.c_str()/*QT_TO_UTF8(ui->customServer->text())*/);
		obs_data_set_bool(settings, "use_auth",
			true/*ui->useAuth->isChecked()*/);
		if (/*ui->useAuth->isChecked()*/1)
		{
			obs_data_set_string(settings, "username",
				username.c_str()/*QT_TO_UTF8(ui->authUsername->text())*/);
			obs_data_set_string(settings, "password",
				password.c_str()/*QT_TO_UTF8(ui->authPw->text())*/);
		}
	}

	obs_data_set_string(settings, "key", key.c_str() /*QT_TO_UTF8(ui->key->text())*/);

	OBSService newService = obs_service_create(service_id,
		"default_service", settings, nullptr);
	obs_service_release(newService);
	SetrtmpParam(newService);
	//SaveService(newService);
	return true;
}

void  CRtmpSetHelp::SetrtmpParam(obs_service_t*p)
{
	obs_frontend_set_streaming_service(p);
	obs_frontend_save_streaming_service();
}

// void CRtmpSetHelp::SaveService(obs_service_t*p)
// {
// 
// 	char serviceJsonPath[512] = {0};
// 	int ret = GetProfilePath(serviceJsonPath, sizeof(serviceJsonPath), SERVICE_PATH);
// 	if (ret <= 0)
// 		return;
// 
// 	obs_data_t *data = obs_data_create();
// 	obs_data_t *settings = obs_service_get_settings(p);
// 
// 	obs_data_set_string(data, "type", obs_service_get_type(p));
// 	obs_data_set_obj(data, "settings", settings);
// 
// 	if (!obs_data_save_json_safe(data, serviceJsonPath, "tmp", "bak"))
// 		blog(LOG_WARNING, "Failed to save service");
// 
// 	obs_data_release(settings);
// 	obs_data_release(data);
// }
